/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requesters;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingBasedRequester
implements IBuildingBasedRequester {
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_ID = "Id";
    private final ILocation location;
    private final IToken<?> requesterId;
    private IRequester building = null;

    public BuildingBasedRequester(ILocation location, IToken<?> requesterId) {
        this.location = location;
        this.requesterId = requesterId;
    }

    public static BuildingBasedRequester deserialize(IFactoryController controller, CompoundNBT compound) {
        ILocation location = (ILocation)controller.deserialize(compound.func_74775_l(NBT_LOCATION));
        IToken token = (IToken)controller.deserialize(compound.func_74775_l(NBT_ID));
        return new BuildingBasedRequester(location, token);
    }

    public CompoundNBT serialize(IFactoryController controller) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(this.getLocation()));
        compound.func_218657_a(NBT_ID, (INBT)controller.serialize(this.getId()));
        return compound;
    }

    public void serialize(IFactoryController controller, PacketBuffer buffer) {
        controller.serialize(buffer, this.getLocation());
        controller.serialize(buffer, this.getId());
    }

    public static BuildingBasedRequester deserialize(IFactoryController controller, PacketBuffer buffer) {
        ILocation location = (ILocation)controller.deserialize(buffer);
        IToken id = (IToken)controller.deserialize(buffer);
        return new BuildingBasedRequester(location, id);
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        this.getBuilding(manager, (IToken<?>)request.getId()).ifPresent(requester -> requester.onRequestedRequestComplete(manager, request));
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        this.getBuilding(manager, (IToken<?>)request.getId()).ifPresent(requester -> requester.onRequestedRequestCancelled(manager, request));
    }

    @Override
    @NotNull
    public IFormattableTextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return this.getBuilding(manager, (IToken<?>)request.getId()).map(requester -> requester.getRequesterDisplayName(manager, request)).orElseGet(() -> new StringTextComponent("<UNKNOWN>"));
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        this.updateBuilding(manager.getColony());
        return Optional.ofNullable(this.building);
    }

    private void updateBuilding(IColony colony) {
        if (this.building != null || this.location == null) {
            return;
        }
        if (colony == null) {
            return;
        }
        this.building = colony.getRequesterBuildingForPosition(this.location.getInDimensionLocation());
    }
}

